﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework;

namespace CashierCrisis.Entities
{

    public class CustomerSpriteComponent : Component
    {
        private MoodComponent moodComponent;
        public string CustomerName { get; set; }
        public CustomerColor Color { get; set; }
        private Texture2D sprite;

        public CustomerSpriteComponent(string name)
            : base(name)
        {
           
        }

        public override void Update(Microsoft.Xna.Framework.GameTime gameTime)
        {
            if (moodComponent.IsNeutral)
            {
                sprite = CustomerSpriteContent.GetSprite(CustomerName, "Neutral", Color);
            } else if (moodComponent.IsHappy)
            {
                sprite = CustomerSpriteContent.GetSprite(CustomerName, "Happy", Color);
            } else if (moodComponent.IsSuperHappy)
            {
                sprite = CustomerSpriteContent.GetSprite(CustomerName, "SuperHappy", Color);
            } else if (moodComponent.IsAngry)
            {
                sprite = CustomerSpriteContent.GetSprite(CustomerName, "Angry", Color);
            }else if (moodComponent.IsSuperAngry)
            {
                sprite = CustomerSpriteContent.GetSprite(CustomerName, "SuperAngry", Color);
            }
            else if (moodComponent.Puzzled)
            {
                sprite = CustomerSpriteContent.GetSprite(CustomerName, "Puzzled", Color);
            }
            else
            {
                sprite = CustomerSpriteContent.GetSprite(CustomerName, "Neutral", Color);
            }

            base.Update(gameTime);
        }

        public Vector2 GetCenter
        {
            get { return new Vector2(sprite.Width / 2, sprite.Height / 2); }
        }

        public Vector2 GetEntityCenter
        {
            get { return new Vector2((sprite.Width / 2) + Entity.Position.X, (sprite.Height / 2) + Entity.Position.Y); }
        }

        public override void Draw(SpriteBatch spriteBatch)
        {
            if(sprite !=null)
                spriteBatch.Draw(sprite, Entity.Position, Microsoft.Xna.Framework.Graphics.Color.White);
            base.Draw(spriteBatch);
        }

        public override void OnAttached(Entity entity)
        {
            moodComponent = Entity.GetComponent("mood") as MoodComponent;
            base.OnAttached(entity);
        }

        


    }
}
